<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:schstdx="https://www.kostentenor.de/SchustersStrukturierteTenordaten">
	
<xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"
  media-type="application/xhtml+xml" />

	<xsl:template
		match="/SchustersStrukturierteTenordaten">
		<html xmlns="http://www.w3.org/1999/xhtml" 
			xml:lang="de" version="XHTML+RDFa 1.1">
			<head>
				<title><xsl:value-of select="berechnungsTyp"/> aus „Schusters kleiner Kostentenor“</title>
				<style type="text/css">

					body {
					font-family: "Tahoma", "Arial", "Helv",
					sans-serif;
					font-size: 16pt;
					color: #111111;
					background-color: White;
					color: #111111;
					}

					a {
					background-color: transparent;
					}

					a:link {
					color:
					#CC0000;
					background-color: transparent;
					text-decoration: none
					}

					a:visited {
					color: #880000;
					background-color: transparent;
					text-decoration: none;
					}

					a:hover {
					color: White;
					background-color:
					#880000
					}

					a:active {
					color: Black;
					background-color: transparent;
					text-decoration: none
					}

					a:focus {
					color: #220000;
					background-color:
					transparent;
					text-decoration: underline;
					}

					a.grafik {
					background-color: transparent;
					}

					a.grafik:hover {
					background-color:
					transparent;
					}

					a.nobreak {
					background-color: transparent;
					white-space:
					nowrap;
					}

					code, tt, kbd {
					font-family: "Lucida Console", "Courier
					New", "Courier", monospace;
					font-size: 100%;
					font-weight: normal;
					color: #222222;
					background-color: transparent;
					}

					div.einrueck {
					margin-top: 0cm;
					margin-right: 0cm;
					margin-bottom: 7.0pt;
					margin-left: 36pt;
					padding-right: 0.2cm;
					padding-left: 0.2cm;
					overflow: hidden;
					border-color: #000033;
					border-width: 1px;
					border-style: solid
					}

					div.einrueck h3 {
					margin-left: 0cm;
					margin-right: 0cm;
					color: White;
					background-color: black;
					border-color: #000033;
					border-width: thin;
					border-style: solid;
					text-align: center
					}

					dl {
					font-family: "Tahoma", "Arial", "Helv",
					sans-serif;
					font-size: 100%;
					line-height: 130%;
					margin-bottom: 7.0pt;
					background-color: transparent;
					font-weight: normal;
					margin-top: 0cm;
					margin-right: 0cm;
					margin-bottom: 7.0pt;
					}

					dt {
					text-indent: 0.3cm;
					font-style: italic;
					font-weight: bold
					}

					dd {
					text-indent: 0.3cm;
					margin-left: 0cm;
					margin-bottom: 7.0pt;
					}

					em, i, cite {
					background-color: transparent;
					color: black
					}

					h1 {
					font-family:
					"BernhardMod BT", "Garamond", "Times New Roman", "Times",
					serif;
					color: #112277;
					background-color: transparent;
					font-size: 72pt;
					font-weight: bold;
					padding: 1.0pt 0cm 6.0pt 0cm;
					margin-bottom:
					0.45cm;
					margin-top: 0.45cm
					}

					h2 {
					font-family: "BernhardMod BT",
					"Garamond", "Times New Roman", "Times",
					serif;
					color: #112277;
					background-color: transparent;
					font-size: 36pt;
					font-weight: bold;
					margin-top: 20.0pt;
					margin-right: 0cm;
					margin-bottom: 10.0pt;
					margin-left: 0cm;
					line-height: 105%;
					border: none;
					padding: 0cm 0cm
					1.0pt 0cm;
					letter-spacing: 1.0pt;
					}

					h3 {
					font-family: "BernhardMod BT",
					"Garamond", "Times New Roman", "Times",
					serif;
					color: #112277;
					background-color: transparent;
					font-size: 24pt;
					font-weight: bold;
					line-height: 105%;
					letter-spacing: .75pt;
					margin-top: 20.0pt;
					margin-right: 0cm;
					margin-bottom: 10.0pt;
					margin-left: 0cm;
					padding:
					0cm 0cm 1.0pt 0cm;
					text-align: center;
					text-transform: uppercase;
					border: none;
					}

					h4 {
					font-family: "BernhardMod BT", "Garamond", "Times
					New Roman", "Times",
					serif;
					color: #112277;
					background-color:
					transparent;
					font-size: 100%;
					margin-bottom: 0.2cm;
					margin-top: 0.4cm;
					clear: right
					}

					h6 {
					font-family: "Tahoma", "Arial", "Helv",
					sans-serif;
					color: black;
					background-color: transparent;
					font-size:
					100%;
					margin-bottom: 0.2cm;
					margin-top: 0.4cm
					}

					.rahmen {
					border-top:
					solid #112277 1.0pt;
					border-left: none;
					border-bottom: solid #112277
					1.0pt;
					border-right: none;
					color: #112277;
					text-align: center
					}

					img {
					border-width: 0;
					}

					img.umfluss, object.umfluss {
					float: right;
					margin:
					4px
					}

					img.links, object.links {
					float: left;
					margin: 4px
					}

					p {
					font-family: "Tahoma", "Arial", "Helv", sans-serif;
					font-size: 100%;
					line-height: 130%;
					margin-bottom: 7.0pt;
					text-align: justify;
					background-color: transparent;
					font-weight: normal
					}

					p.text {
					text-indent: 0.3cm;
					}

					p.pre {
					font-family: "Lucida Console", "Courier
					New", "Courier", monospace;
					background-color: transparent;
					text-align: left;
					margin-left: 36pt;
					}

					strong, b {
					background-color:
					transparent;
					color: #112255;
					font-variant: small-caps;
					font-weight:
					bold
					}

					small {
					background-color: transparent;
					font-size: 71%;
					line-height: 0.25cm
					}

					sup {
					background-color: transparent;
					font-size:
					60%;
					vertical-align: text-top;
					color: #112255
					}

					td {
					font-family:
					"Tahoma", "Arial", "Helv", sans-serif;
					font-size: 71%;
					background-color: transparent;
					font-weight: normal;
					vertical-align:
					top;
					text-align: left;
					color: black
					}

					th {
					font-family: "Tahoma",
					"Arial", "Helv", sans-serif;
					font-size: 71%;
					background-color:
					transparent;
					font-weight: normal;
					vertical-align: top;
					text-align:
					right;
					color: #112255
					}

					ul, ol, li {
					font-family: "Tahoma", "Arial",
					"Helv", sans-serif;
					font-size: 100%;
					line-height: 130%;
					margin-bottom: 7.0pt;
					background-color: transparent;
					font-weight:
					normal;
					margin-top: 0cm;
					margin-right: 0cm;
					margin-bottom: 7.0pt;
					margin-left: 14pt;
					}

					.kleingedrucktes, .kleingedrucktes li {
					font-family: "Lucida Console", "Courier New", "Courier", monospace;
					font-size: 81%;
					}
				</style>
			</head>
			<body>
				<h1>Aus „Schusters kleiner Kostentenor“: <xsl:value-of select="berechnungsTyp"/></h1>
				<xsl:apply-templates />
			</body>
		</html>
	</xsl:template>

	<xsl:template match="programminfo">
		<h2>Programminformationen</h2>
		<table>
			<thead>
				<tr>
					<th>Kostentenor-Version</th>
					<th>Betriebssystem</th>
					<th>-Zweig</th>
					<th>-Version</th>
					<th>Java-Hersteller</th>
					<th>-Name</th>
					<th>-Version</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						<xsl:value-of select="./@version" />
					</td>
					<td>
						<xsl:value-of select="./@osName" />
					</td>
					<td>
						<xsl:value-of select="./@osArch" />
					</td>
					<td>
						<xsl:value-of select="./@osVersion" />
					</td>
					<td>
						<xsl:value-of select="./@javaVendor" />
					</td>
					<td>
						<xsl:value-of select="./@javaName" />
					</td>
					<td>
						<xsl:value-of select="./@javaVersion" />
					</td>
				</tr>
			</tbody>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="hauptsache">
		<h2>Entscheidung in der Hauptsache</h2>
		<p>
			<xsl:value-of select="./text" />
		</p>
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="hauptsacheVerurteilungen">
		<table>
			<thead>
				<tr>
					<th>Gläubiger</th>
					<th>Schuldner</th>
					<th>darüber hinaus?</th>
					<th>Verurteilung</th>
				</tr>
			</thead>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="kosten">
		<h2>Entscheidung über
			die Kosten
		</h2>
		<p>
			<xsl:value-of select="./text" />
		</p>
		<table>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="kostenTragungsVerhaeltnis">
		<table>
			<thead>
				<tr>
					<th>Gläubiger</th>
					<th>Schuldner</th>
					<th>darüber hinaus?</th>
					<th>trägt Kosten zu</th>
				</tr>
			</thead>
		</table>
	</xsl:template>

	<xsl:template match="vorlaeufigVollstreckbar">
		<h2>Entscheidung über
			die vorläufige
			Vollstreckbarkeit
		</h2>
		<p>
			<xsl:value-of select="./text" />
		</p>
		<table>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="vollstreckungsVerhaeltnis">
		<table>
			<thead>
				<tr>
					<th>Gläubiger</th>
					<th>Schuldner</th>
					<th>Vollstreckbarkeit nach Vorschriften</th>
				</tr>
			</thead>
		</table>
	</xsl:template>

	<xsl:template match="streitwertEntscheidung">
		<h2>Entscheidung über
			den Streitwert
		</h2>
		<p>
			<xsl:value-of select="./text" />
		</p>
		<table>
			<xsl:apply-templates />
		</table>
	</xsl:template>
</xsl:stylesheet>